/* SwitchView.h
 * Written By:  Thomas Burkholder
 *
 * You may freely copy, distribute, and reuse the code in this example.
 * NeXT disclaims any warranty of any kind, expressed or  implied, as to its
 * fitness for any particular use.
 */


#import <AppKit/AppKit.h>

#define MC_SV_CONN_SEQ	@"seq"
#define MC_SV_CONN_KEY	@"key"

typedef enum _MCWindowResizeBehaviour{
    MCWindowResizeNone			= 0,
    MCWindowResizeHeightOnly		= 1,
    MCWindowResizeWidthOnly		= 2,
    MCWindowResizeAll			= 3
}MCWindowResizeBehaviour;


// A Box subclass that can swap views in and out of it's content view
@interface MCSwitchView:NSBox
{
    NSMutableArray	*views;	// list of views to be shown
    NSMutableArray	*keys;	// Keys for the views (used to bind or select views)
    SEL	valueSelector;		// callback method to control
    int	initialViewNumber;	// number of the first view to show
    
    int windowResizeBehaviour;
    NSView		*bogusView;

    NSMutableArray	*stagedConnections;
    int			currentViewIndex;
}

- initWithFrame:(NSRect)frameRect;
- (void)dealloc;
- (NSMutableArray *)views;
- (void)switchToView:(int)aNum;
- (void)switchToViewWithKey:(NSString *)aKey;


- (void)insertView:(NSView *)aView withKey:(NSString *)aKey atIndex:(int)index;
- (void)addView:(NSView *)aView withKey:(NSString *)aKey;

- (id)viewWithTag:(int)aTag;
- (id)viewAtIndex:(int)aNum;
- (id)viewWithKey:(NSString *)aKey;



- (int)currentViewIndex;

- (void)directSwitchToView:(NSView *)aView;




// action method to use to swap in a view
- (void)takeViewNumberFrom:sender;
- (void)takeTagFrom:sender;
- (void)takeIntValueFrom:sender;
- (void)takeSelectedRowFrom:sender;
- (void)takeSelectedColFrom:sender;

// toggles between view 0 and view 1 -- ignores others
- (IBAction)toggleFirstViews:(id)sender;


- (void)setValueSelector:(SEL)aSelector;  // use to set the callback
- (SEL)valueSelector;
- (void)setInitialViewNumber:(int)num;
- (int)initialViewNumber;
- (void)setWindowResizeBehaviour:(MCWindowResizeBehaviour)aBehav;
- (MCWindowResizeBehaviour)windowResizeBehaviour;
- (SEL)guessValueSelectorForSwitchSource:sender;
- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end
